/**************************************************************************************
  $Id: HostInformation.cpp 13332 2019-11-11 12:40:25Z Robert $

  Description:
    Host Information Dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-07-16  initial version

 **************************************************************************************/

#include "stdafx.h"
#include "cifXTCPServer.h"
#include "HostInformation.h"
#include "cifXUser.h"
#include "cifXErrors.h"
#include "TCPConnector.h"

// HostInformation dialog

IMPLEMENT_DYNAMIC(HostInformation, CDialog)
HostInformation::HostInformation(CWnd* pParent /*=NULL*/)
	: CDialog(HostInformation::IDD, pParent)
{
}

HostInformation::~HostInformation()
{
}

void HostInformation::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_DEVICETREE, m_cTreeCtrl);
}

/*****************************************************************************/
/*! This function is called in response to the WM_INITDIALOG message.        */
/*****************************************************************************/
BOOL HostInformation::OnInitDialog()
{
  CDialog::OnInitDialog();

  uint32_t ulBoardIdx = 0;
  int32_t  lBoardRet  = CIFX_NO_ERROR;
  char     szIPAddress[15];

  if (HIL_MARSHALLER_E_SUCCESS == TCPConnectorGetLocalIP(szIPAddress, sizeof(szIPAddress)))
  {
    CString csIPAddress = CString(_T("Local IP Address: ")) + CString(szIPAddress);
    SetDlgItemText(IDC_IPADDRESS, csIPAddress);
  }

  while(lBoardRet == CIFX_NO_ERROR)
  {
    // Enumerate the boards
    BOARD_INFORMATION tBoardInfo = {0};
    if(CIFX_NO_ERROR == (lBoardRet = xDriverEnumBoards(NULL, ulBoardIdx, sizeof(tBoardInfo), &tBoardInfo)))
    {
      CString   csTmp;
      HTREEITEM hDevice = m_cTreeCtrl.InsertItem(CString(tBoardInfo.abBoardName));
      
      csTmp = CString(_T("Alias: ")) + CString(tBoardInfo.abBoardAlias);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Device Number: %d"), tBoardInfo.tSystemInfo.ulDeviceNumber);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Serial Number: %d"), tBoardInfo.tSystemInfo.ulSerialNumber);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Channels: %d"), tBoardInfo.ulChannelCnt);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("DPM Size: %d"), tBoardInfo.ulDpmTotalSize);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      m_cTreeCtrl.Expand(hDevice, TVE_EXPAND);
      ++ulBoardIdx;
    }
  }
  return TRUE;
}


BEGIN_MESSAGE_MAP(HostInformation, CDialog)
END_MESSAGE_MAP()


// HostInformation message handlers
